/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.event.WorldEvent;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.dimensions.DimensionHandler;
import noppes.npcs.util.Util;

public class CmdScript
extends CommandNoppesBase {
    @Override
    public int func_82362_a() {
        return 4;
    }

    @CommandNoppesBase.SubCommand(desc="List of available event names from all APIs in mod", permission=4)
    public Boolean apilist(MinecraftServer server, ICommandSender sender, String[] args) {
        StringBuilder list = new StringBuilder();
        ArrayList<String> g = new ArrayList<String>();
        for (EnumScriptType est : EnumScriptType.values()) {
            g.add(est.function);
        }
        Collections.sort(g);
        for (String name : g) {
            if (list.length() > 0) {
                list.append(", ");
            } else {
                list.append("\u00a76Mod APIs event names:\n\u00a7r");
            }
            list.append(name);
        }
        list.append(";\n\u00a76Total Size: \u00a7e").append(g.size());
        sender.func_145747_a((ITextComponent)new TextComponentString(list.toString()));
        if (sender instanceof EntityPlayerMP) {
            Server.sendData((EntityPlayerMP)sender, EnumPacketClient.EVENT_NAMES, list.toString());
        }
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="List of available Forge event names", permission=4)
    public Boolean clientlist(MinecraftServer server, ICommandSender sender, String[] args) {
        StringBuilder list = new StringBuilder();
        ArrayList<String> g = new ArrayList<String>(ScriptController.forgeClientEventNames.values());
        Collections.sort(g);
        for (String name : g) {
            if (list.length() > 0) {
                list.append(", ");
            } else {
                list.append("\u00a76Client forge event names:\n\u00a7r");
            }
            list.append(name);
        }
        list.append(";\n\u00a76Total Size: \u00a7e").append(g.size());
        sender.func_145747_a((ITextComponent)new TextComponentString(list.toString()));
        if (sender instanceof EntityPlayerMP) {
            Server.sendData((EntityPlayerMP)sender, EnumPacketClient.EVENT_NAMES, list.toString());
        }
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="List of available Forge event names", permission=4)
    public Boolean forgelist(MinecraftServer server, ICommandSender sender, String[] args) {
        StringBuilder list = new StringBuilder();
        ArrayList<String> g = new ArrayList<String>(ScriptController.forgeEventNames.values());
        Collections.sort(g);
        for (String name : g) {
            if (list.length() > 0) {
                list.append(", ");
            } else {
                list.append("\u00a76Server Forge event names:\n\u00a7r");
            }
            list.append(name);
        }
        list.append(";\n\u00a76Total Size: \u00a7e").append(g.size());
        sender.func_145747_a((ITextComponent)new TextComponentString(list.toString()));
        if (sender instanceof EntityPlayerMP) {
            Server.sendData((EntityPlayerMP)sender, EnumPacketClient.EVENT_NAMES, list.toString());
        }
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Displays all script owners that have logs.", permission=4)
    public Boolean logs(MinecraftServer server, ICommandSender sender, String[] args) {
        LinkedHashMap<String, ITextComponent> map = new LinkedHashMap<String, ITextComponent>();
        for (ScriptContainer container : ScriptController.Instance.getErrored()) {
            ITextComponent message = container.noticeString();
            map.put(Util.instance.deleteColor(message.func_150254_d()), message);
        }
        if (map.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.script.logs.empty", new Object[0]));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.script.logs.info", new Object[0]));
            for (ITextComponent message : map.values()) {
                sender.func_145747_a(message);
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.script.logs.end", new Object[0]));
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Reload scripts and saved data from disks script folder.", permission=4)
    public Boolean reload(MinecraftServer server, ICommandSender sender, String[] args) {
        ScriptController.Instance.loadCategories();
        if (ScriptController.Instance.loadPlayerScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload player scripts successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading player scripts"));
        }
        if (ScriptController.Instance.loadNPCsScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload NPCs scripts successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading NPCs scripts"));
        }
        if (ScriptController.Instance.loadForgeScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload forge scripts successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading forge scripts"));
        }
        if (ScriptController.Instance.loadClientScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload client scripts successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading client scripts"));
        }
        if (ScriptController.Instance.loadPotionScripts()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload potion scripts successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading potion scripts"));
        }
        if (ScriptController.Instance.loadConstantData()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload constant data successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading constant data"));
        }
        if (ScriptController.Instance.loadStoredData()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Reload stored data successfully"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Failed reloading stored data"));
        }
        if (server != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                ScriptController.Instance.sendClientTo(player);
            }
        }
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Runs scriptCommand in the players scripts", usage="[args]", permission=4)
    public Boolean run(MinecraftServer server, ICommandSender sender, String[] args) {
        IWorld world = Objects.requireNonNull(NpcAPI.Instance()).getIWorld(sender.func_130014_f_());
        BlockPos bpos = sender.func_180425_c();
        IPos pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(bpos.func_177958_n(), bpos.func_177956_o(), bpos.func_177952_p());
        WorldEvent.ScriptCommandEvent event = new WorldEvent.ScriptCommandEvent(world, pos, args);
        EventHooks.onWorldScriptEvent(event);
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Attempts to execute on the specified object", usage="<dimensionID> <x> <y> <z> <entity> <triggerID> [Strings]", permission=4)
    public Boolean trigger(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int id;
        IEntity<?>[] entitys;
        IWorld world;
        IPos pos = null;
        IEntity<?> entity = null;
        try {
            int dimID = Integer.parseInt(args[0]);
            if (!DimensionManager.isDimensionRegistered((int)dimID) || DimensionHandler.getInstance().isDelete(dimID)) {
                throw new CommandException("DimensionID: " + dimID + " - not found", new Object[0]);
            }
            world = Objects.requireNonNull(NpcAPI.Instance()).getIWorld(dimID);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("DimensionID \"" + args[0] + "\" - must be an integer ", new Object[0]);
        }
        try {
            double dx = CmdScript.func_175770_a((double)sender.func_180425_c().func_177958_n(), (String)args[1], (boolean)true).func_179628_a();
            double dy = CmdScript.func_175767_a((double)sender.func_180425_c().func_177956_o(), (String)args[2], (int)0, (int)255, (boolean)false).func_179628_a();
            double dz = CmdScript.func_175770_a((double)sender.func_180425_c().func_177952_p(), (String)args[3], (boolean)true).func_179628_a();
            pos = Objects.requireNonNull(NpcAPI.Instance()).getIPos(dx, dy, dz);
        }
        catch (NumberFormatException e) {
            LogWriter.error(e);
        }
        for (IEntity<?> e : entitys = world.getNearbyEntities(pos, 2, 0)) {
            if ((!args[4].equalsIgnoreCase("player") || e.getType() != 1) && !e.getName().equalsIgnoreCase(args[4])) continue;
            entity = e;
            break;
        }
        try {
            id = Integer.parseInt(args[5]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("TriggerID \"" + args[0] + "\" must be an integer", new Object[0]);
        }
        Object[] arguments = new String[args.length - 6];
        System.arraycopy(args, 6, arguments, 0, args.length - 6);
        if (entity == null) {
            assert (pos != null);
            TileEntity tile = world.getMCWorld().func_175625_s(pos.getMCBlockPos());
            if (tile instanceof TileScripted) {
                EventHooks.onScriptTriggerEvent((TileScripted)tile, id, world, pos, null, arguments);
                return true;
            }
        }
        EventHooks.onScriptTriggerEvent(id, world, pos, entity, arguments);
        return true;
    }

    @CommandNoppesBase.SubCommand(desc="Display a list of all load script elements positions in chat", permission=4)
    public Boolean list(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ITextComponent positions;
        String key;
        switch (key = args.length > 0 ? args[0] : "all") {
            case "blocks": {
                positions = ScriptController.Instance.getElements(0);
                if (positions == null) break;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.blocks", new Object[0]));
                sender.func_145747_a(positions);
                break;
            }
            case "doors": {
                positions = ScriptController.Instance.getElements(1);
                if (positions == null) break;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.doors", new Object[0]));
                sender.func_145747_a(positions);
                break;
            }
            case "npcs": {
                positions = ScriptController.Instance.getElements(2);
                if (positions == null) break;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.npcs", new Object[0]));
                sender.func_145747_a(positions);
                break;
            }
            case "all": {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.all", new Object[0]));
                positions = ScriptController.Instance.getElements(0);
                if (positions != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.blocks", new Object[0]));
                    sender.func_145747_a(positions);
                }
                if ((positions = ScriptController.Instance.getElements(1)) != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.doors", new Object[0]));
                    sender.func_145747_a(positions);
                }
                if ((positions = ScriptController.Instance.getElements(2)) == null) break;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.npcs", new Object[0]));
                sender.func_145747_a(positions);
                break;
            }
            default: {
                throw new CommandException("Unknown type \"" + key + "\"", new Object[0]);
            }
        }
        if (positions == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("script.command.not.found", new Object[0]));
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "Commands for scripts";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "script";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            switch (args[0]) {
                case "clientlist": {
                    return new ArrayList<String>(ScriptController.forgeClientEventNames.values());
                }
                case "forgelist": {
                    return new ArrayList<String>(ScriptController.forgeEventNames.values());
                }
                case "apilist": {
                    for (EnumScriptType est : EnumScriptType.values()) {
                        list.add(est.function);
                    }
                    break;
                }
                case "list": {
                    list.add("blocks");
                    list.add("doors");
                    list.add("npcs");
                    list.add("all");
                }
            }
        }
        return list;
    }
}

